/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity.model;

import com.google.common.collect.ImmutableList;
import net.adventurez.entity.EnderwarthogEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

@Environment(value=EnvType.CLIENT)
public class EnderwarthogModel<T extends EnderwarthogEntity>
extends ListModel<T> {
    private final ModelPart mainbody;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart ribbon1L;
    private final ModelPart ribbon2L;
    private final ModelPart ribbon1R;
    private final ModelPart ribbon2R;
    private final ModelPart horn1L;
    private final ModelPart horn2L;
    private final ModelPart horn3L;
    private final ModelPart horn1R;
    private final ModelPart horn2R;
    private final ModelPart horn3R;
    private final ModelPart legfL;
    private final ModelPart legbL;
    private final ModelPart legfR;
    private final ModelPart legbR;

    public EnderwarthogModel(ModelPart root) {
        this.mainbody = root.m_171324_("mainbody");
        this.legbR = this.mainbody.m_171324_("legbR");
        this.legfR = this.mainbody.m_171324_("legfR");
        this.legbL = this.mainbody.m_171324_("legbL");
        this.legfL = this.mainbody.m_171324_("legfL");
        this.neck = this.mainbody.m_171324_("neck");
        this.horn1R = this.neck.m_171324_("horn1R");
        this.horn2R = this.horn1R.m_171324_("horn2R");
        this.horn3R = this.horn2R.m_171324_("horn3R");
        this.horn1L = this.neck.m_171324_("horn1L");
        this.horn2L = this.horn1L.m_171324_("horn2L");
        this.horn3L = this.horn2L.m_171324_("horn3L");
        this.head = this.neck.m_171324_("head");
        this.ribbon1R = this.head.m_171324_("ribbon1R");
        this.ribbon2R = this.ribbon1R.m_171324_("ribbon2R");
        this.ribbon1L = this.head.m_171324_("ribbon1L");
        this.ribbon2L = this.ribbon1L.m_171324_("ribbon2L");
        this.jaw = this.head.m_171324_("jaw");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        PartDefinition modelPartData1 = modelPartData.m_171599_("mainbody", CubeListBuilder.m_171558_().m_171514_(0, 190).m_171481_(-10.5f, -8.5f, -16.5f, 21.0f, 19.0f, 36.0f), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition modelPartData2 = modelPartData1.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(0, 10).m_171481_(-8.5f, -7.5f, -15.0f, 17.0f, 18.0f, 15.0f), PartPose.m_171419_((float)0.0f, (float)-3.5f, (float)-10.0f));
        PartDefinition modelPartData3 = modelPartData2.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(180, 20).m_171481_(-6.5f, -3.6f, -13.0f, 13.0f, 7.0f, 17.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-17.0f));
        PartDefinition modelPartData4 = modelPartData3.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(180, 60).m_171481_(-7.0f, -2.5f, -16.0f, 14.0f, 5.0f, 18.0f), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)2.0f));
        modelPartData4.m_171599_("jawguard", CubeListBuilder.m_171558_().m_171514_(180, 100).m_171481_(-7.0f, -3.0f, -8.0f, 14.0f, 3.0f, 18.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-8.0f));
        PartDefinition modelPartData5 = modelPartData3.m_171599_("ribbon1L", CubeListBuilder.m_171558_().m_171514_(140, 0).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 9.0f), PartPose.m_171419_((float)-4.0f, (float)-3.5f, (float)0.0f));
        modelPartData5.m_171599_("ribbon2L", CubeListBuilder.m_171558_().m_171514_(140, 20).m_171481_(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)9.0f));
        PartDefinition modelPartData6 = modelPartData3.m_171599_("ribbon1R", CubeListBuilder.m_171558_().m_171514_(140, 0).m_171506_(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 9.0f, true), PartPose.m_171419_((float)4.0f, (float)-3.5f, (float)0.0f));
        modelPartData6.m_171599_("ribbon2R", CubeListBuilder.m_171558_().m_171514_(140, 20).m_171506_(-1.5f, 0.0f, 0.0f, 3.0f, 0.0f, 9.0f, true), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)9.0f));
        PartDefinition modelPartData7 = modelPartData2.m_171599_("horn1L", CubeListBuilder.m_171558_().m_171514_(80, 0).m_171506_(-10.0f, -3.5f, -5.0f, 10.0f, 7.0f, 7.0f, true), PartPose.m_171419_((float)-6.0f, (float)-2.0f, (float)-9.1f));
        PartDefinition modelPartData8 = modelPartData7.m_171599_("horn2L", CubeListBuilder.m_171558_().m_171514_(80, 20).m_171506_(-10.0f, -2.5f, -2.5f, 10.0f, 5.0f, 5.0f, true), PartPose.m_171419_((float)-8.0f, (float)-1.0f, (float)-1.0f));
        modelPartData8.m_171599_("horn3L", CubeListBuilder.m_171558_().m_171514_(80, 40).m_171506_(-8.0f, -2.5f, -2.5f, 9.0f, 4.0f, 4.0f, true), PartPose.m_171419_((float)-9.0f, (float)0.4f, (float)0.0f));
        PartDefinition modelPartData9 = modelPartData2.m_171599_("horn1R", CubeListBuilder.m_171558_().m_171514_(80, 0).m_171481_(0.0f, -3.5f, -5.0f, 10.0f, 7.0f, 7.0f), PartPose.m_171419_((float)6.0f, (float)0.0f, (float)-8.9f));
        PartDefinition modelPartData10 = modelPartData9.m_171599_("horn2R", CubeListBuilder.m_171558_().m_171514_(80, 20).m_171481_(0.0f, -2.5f, -2.5f, 10.0f, 5.0f, 5.0f), PartPose.m_171419_((float)8.0f, (float)-1.0f, (float)-1.0f));
        modelPartData10.m_171599_("horn3R", CubeListBuilder.m_171558_().m_171514_(80, 40).m_171481_(-1.0f, -2.5f, -2.5f, 9.0f, 4.0f, 4.0f), PartPose.m_171419_((float)9.0f, (float)0.4f, (float)0.0f));
        PartDefinition modelPartData11 = modelPartData1.m_171599_("legfL", CubeListBuilder.m_171558_().m_171514_(0, 120).m_171481_(-4.0f, 0.0f, -4.5f, 8.0f, 24.0f, 9.0f), PartPose.m_171419_((float)-10.0f, (float)-3.0f, (float)-11.0f));
        modelPartData11.m_171599_("thighfLL", CubeListBuilder.m_171558_().m_171514_(40, 130).m_171488_(-7.0f, 0.0f, -4.5f, 8.0f, 8.0f, 9.0f, new CubeDeformation(0.3f)), PartPose.m_171419_((float)3.0f, (float)0.0f, (float)0.0f));
        PartDefinition modelPartData12 = modelPartData1.m_171599_("legbL", CubeListBuilder.m_171558_().m_171514_(0, 70).m_171481_(-4.0f, 0.0f, -4.5f, 8.0f, 24.0f, 9.0f), PartPose.m_171419_((float)-10.0f, (float)-3.0f, (float)13.0f));
        modelPartData12.m_171599_("thighbL", CubeListBuilder.m_171558_().m_171514_(40, 90).m_171488_(-8.0f, 0.0f, -4.5f, 8.0f, 8.0f, 9.0f, new CubeDeformation(0.3f)), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition modelPartData13 = modelPartData1.m_171599_("legfR", CubeListBuilder.m_171558_().m_171514_(0, 120).m_171481_(-4.0f, 0.0f, -4.5f, 8.0f, 24.0f, 9.0f), PartPose.m_171419_((float)10.0f, (float)-3.0f, (float)-11.0f));
        modelPartData13.m_171599_("thighfLR", CubeListBuilder.m_171558_().m_171514_(40, 130).m_171488_(0.0f, 0.0f, -4.5f, 8.0f, 8.0f, 9.0f, new CubeDeformation(0.3f)), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition modelPartData14 = modelPartData1.m_171599_("legbR", CubeListBuilder.m_171558_().m_171514_(0, 70).m_171481_(-4.0f, 0.0f, -4.5f, 8.0f, 24.0f, 9.0f), PartPose.m_171419_((float)10.0f, (float)-3.0f, (float)13.0f));
        modelPartData14.m_171599_("thighbR", CubeListBuilder.m_171558_().m_171514_(40, 90).m_171488_(0.0f, 0.0f, -4.5f, 8.0f, 8.0f, 9.0f, new CubeDeformation(0.3f)), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)256, (int)256);
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.mainbody);
    }

    public void setAngles(T entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.head.f_104203_ = 0.2602f + headPitch * 0.010453292f;
        this.neck.f_104204_ = headYaw * 0.004453292f;
        this.head.f_104204_ = headYaw * 0.005453292f;
        this.jaw.f_104203_ = 0.0524f;
        this.ribbon1L.f_104203_ = 0.7854f;
        this.ribbon1L.f_104204_ = -0.4712f;
        this.ribbon2L.f_104203_ = -0.3491f;
        this.ribbon2L.f_104204_ = 0.2443f;
        this.ribbon1R.f_104203_ = 0.7854f;
        this.ribbon1R.f_104204_ = 0.4712f;
        this.ribbon2R.f_104203_ = -0.3491f;
        this.ribbon2R.f_104204_ = -0.2443f;
        this.horn1L.f_104203_ = 0.1022f;
        this.horn1L.f_104204_ = -0.2274f;
        this.horn1L.f_104205_ = -0.8633f;
        this.horn2L.f_104203_ = -0.0524f;
        this.horn2L.f_104204_ = -0.5411f;
        this.horn2L.f_104205_ = -0.3142f;
        this.horn3L.f_104203_ = 0.2269f;
        this.horn3L.f_104204_ = -0.576f;
        this.horn3L.f_104205_ = -0.2793f;
        this.horn1R.f_104203_ = -0.1047f;
        this.horn1R.f_104204_ = 0.3142f;
        this.horn1R.f_104205_ = 0.8727f;
        this.horn2R.f_104203_ = 0.0524f;
        this.horn2R.f_104204_ = 0.5411f;
        this.horn2R.f_104205_ = 0.3142f;
        this.horn3R.f_104203_ = 0.2269f;
        this.horn3R.f_104204_ = 0.576f;
        this.horn3R.f_104205_ = 0.2793f;
        this.legbR.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 0.8f * limbDistance;
        this.legbL.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 0.8f * limbDistance;
        this.legfR.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f + (float)Math.PI)) * 0.8f * limbDistance;
        this.legfL.f_104203_ = Mth.m_14089_((float)(limbAngle * 0.6662f)) * 0.8f * limbDistance;
        float k = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI));
        if (k > 0.0f) {
            if (((Boolean)entity.m_20088_().m_135370_(EnderwarthogEntity.BITE_ATTACK)).booleanValue()) {
                this.neck.f_104203_ = -k * 0.05f;
                this.head.f_104203_ = -k * 0.01f;
                this.jaw.f_104203_ = 0.0524f + k * 0.45f;
            } else {
                this.neck.f_104203_ = -k * 0.4f;
                this.head.f_104203_ = -k * 0.2f;
            }
        } else {
            this.neck.f_104203_ = 0.0f;
        }
    }
}

